function starcat(star,cons,name,ra_h,ra_m,ra_s,de_g,de_p,de_ss,mpra_h,mpra_m,mpra_s,mpde_g,mpde_p,mpde_ss,ra_h1,ra_m1,ra_s1,sgn_dec,de_g1,de_p1,de_ss1,sgn_h,h_g,h_p,h_ss,a_g,a_p,a_ss,sgn_e,laec_g,laec_p,laec_ss,loec_g,loec_p,loec_ss,mg,al,type,spec)
	{
	this.star=star;
	this.cons=cons;
	this.name=name;
	this.ra_h=ra_h;
	this.ra_m=ra_m;
	this.ra_s=ra_s;
	this.de_g=de_g;
	this.de_p=de_p;
	this.de_ss=de_ss;
	this.mpra_h=mpra_h;
	this.mpra_m=mpra_m;
	this.mpra_s=mpra_s;
	this.mpde_g=mpde_g;
	this.mpde_p=mpde_p;
	this.mpde_ss=mpde_ss;
	this.ra_h1=ra_h1;
	this.ra_m1=ra_m1;
	this.ra_s1=ra_s1;
	this.sgn_dec=sgn_dec;
	this.de_g1=de_g1;
	this.de_p1=de_p1;
	this.de_ss1=de_ss1;
	this.sgn_h=sgn_h;
	this.h_g=h_g;
	this.h_p=h_p;
	this.h_ss=h_ss;
	this.a_g=a_g;
	this.a_p=a_p;
	this.a_ss=a_ss;
	this.sgn_e=sgn_e;
	this.laec_g=laec_g;
	this.laec_p=laec_p;
	this.laec_ss=laec_ss;
	this.loec_g=loec_g;
	this.loec_p=loec_p;
	this.loec_ss=loec_ss;
	this.mg=mg;
	this.al=al;
	this.type=type;
	this.spec=spec
}
function stelle(obj)
	{
	if(obj.FIRMA.value=="     Agostino Frosini  -  Javascript Software 2015  -")
		{
		var stars=new Array(new starcat("&alpha;","Acquario","Sadalmelik",22,5,47.033,-0,-19,-11.38,0,0,0.0013,0,0,-0.009,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.10","758.50","SS","G0"),new starcat("&beta;","Acquario","Sadalsuud",21,31,33.545,-5,-34,-16.27,0,0,0.0015,0,0,-0.008,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.1","611.93","SD","G0"),new starcat("&delta;","Acquario","Skat",22,54,39.019,-15,-49,-14.95,0,0,-0.0027,0,0,-0.025,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.50","159.57","SS","A2"),new starcat("&gamma;","Acquario","Sadachbia",22,21,39.376,-1,-23,-14.37,0,0,0.0088,0,0,0.007,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.00","157.79","SD","A0"),new starcat("&alpha;","Andromeda","Alpheratz",0,8,23.269,29,5,25.55,0,0,0.0104,0,0,-0.163,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.10","97.07","SD","A0"),new starcat("&beta;","Andromeda","Mirach",1,9,43.942,35,37,13.93,0,0,0.0147,0,0,-0.113,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.40","199.36","SD","M0"),new starcat("&alpha;","Aquila","Altair",19,50,47.001,8,52,6.07,0,0,0.0363,0,0,0.387,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","0.90","16.77","SD","A5"),new starcat("&gamma;","Aquila","Tarazed",19,46,15.59,10,36,47.91,0,0,0.0012,0,0,0.000,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.80","460.67","SS","K2"),new starcat("&alpha;","Ariete","Hamal",2,7,1.398,23,27,44.61,0,0,0.0138,0,0,-0.149,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.20","65.92","SS","K2"),new starcat("&beta;","Ariete","Sharatan",1,54,38.402,20,48,28.73,0,0,0.0069,0,0,-0.112,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.70","59.58","SS","A5"),new starcat("&alpha;","Auriga","Capella",5,16,41.358,45,59,52.98,0,0,0.0074,0,0,-0.424,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","0.20","42.20","SS","G0"),new starcat("&beta;","Auriga","Menkalinan",5,59,31.733,44,56,50.72,0,0,-0.0053,0,0,-0.000,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.10","82.11","SD","A0"),new starcat("&beta;","Bilancia","Zuben Elschemali",15,17,0.43,-9,-22,-58.53,0,0,-0.0064,0,0,-0.019,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.70","160.04","SS","B8"),new starcat("&gamma;","Bilancia","Zuben Elakrab",15,35,31.582,-14,-47,-22.5,0,0,0.0045,0,0,0.008,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.00","152.27","SD","K0"),new starcat("&alpha;","Bootes","Arcturus",14,15,39.687,19,10,56.77,0,0,-0.077,0,0,-1.998,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","0.2","36.71","SS","K0"),new starcat("&beta;","Bootes","Nekkar",15,1,56.75,40,23,26,0,0,-0.0036,0,0,-0.028,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.60","218.75","SS","G5"),new starcat("&epsilon;","Bootes","Izar",14,44,59.229,27,4,27.14,0,0,-0.0037,0,0,0.021,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.70","209.75","SD","K0"),new starcat("&eta;","Bootes","Mufrid",13,54,41.076,18,23,51.72,0,0,-0.0044,0,0,-0.358,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.80","36.99","SS","G0"),new starcat("&delta;","Capricorno","Deneb Algedi",21,47,2.458,-16,-7,-38.19,0,0,0.0184,0,0,-0.296,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.00","38.56","SD","A5"),new starcat("&alpha;","Carina","Canopus",6,23,57.183,-52,-41,-44.44,0,0,0.0034,0,0,0.021,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","-0.90","312.71","SS","F0"),new starcat("&alpha;","Cassiopeia","Schedar",0,40,30.465,56,32,14.43,0,0,0.0065,0,0,-0.032,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.50","228.56","SD","K0"),new starcat("&beta;","Cassiopeia","Caph",0,9,1.791,59,8,58.99,0,0,0.0686,0,0,-0.183,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.40","54.46","SD","F5"),new starcat("&alpha;","Cefeo","Adleramin",21,18,34.783,62,35,8.02,0,0,0.022,0,0,0.049,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.60","48.80","SD","A5"),new starcat("&beta;","Cefeo","Alfirk",21,28,39.628,70,33,38.67,0,0,0.0024,0,0,0.008,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.30","595.18","SD","B1"),new starcat("&gamma;","Cefeo","Errai",23,39,20.864,77,37,56.56,0,0,-0.0205,0,0,0.149,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.40","44.99","SS","K0"),new starcat("&alpha;","Centauro","Rigil&nbsp;Kentaurus",14,39,36.167,-60,-50,-7.35,0,0,-0.4949,0,0,0.699,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","-0.1","4.39","SD","G2"),new starcat("&beta;","Centauro","Agena",14,3,49.462,-60,-22,-22.73,0,0,-0.0035,0,0,-0.019,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","0.90","525.21","SD","B1"),new starcat("&alpha;","Balena","Menkar",3,2,16.777,4,5,22.93,0,0,-0.0006,0,0,-0.078,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.80","220.08","SS","M0"),new starcat("&beta;","Balena","Diphda",0,43,35.383,-17,-59,-11.85,0,0,0.0165,0,0,0.032,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.20","95.82","SS","K0"),new starcat("o","Balena","Mira",2,19,20.729,-2,-58,-39.42,0,0,-0.0005,0,0,-0.237,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.00","418.69","SD","M5"),new starcat("&zeta;","Balena","Baten Kaitos",1,51,27.638,-10,-20,-6.19,0,0,0.0027,0,0,-0.039,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.90","259.06","SS","K0"),new starcat("&alpha;","Cane Maggiore","Sirius",6,45,8.917,-16,-42,-58.11,0,0,-0.0379,0,0,-1.206,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","-1.60","8.60","SD","A0"),new starcat("&beta;","Cane Maggiore","Murzim",6,22,41.966,-17,-57,-21.59,0,0,-0.0005,0,0,-0.002,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.00","499.47","SS","B1"),new starcat("&epsilon;","Cane Maggiore","Adharaz",6,58,37.561,-28,-58,-19.41,0,0,0.0005,0,0,0.004,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.60","430.85","SD","B1"),new starcat("&alpha;","Cane Minore","Procyon",7,39,18.123,5,13,29.95,0,0,-0.0474,0,0,-1.024,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","0.50","11.41","SD","F5"),new starcat("&beta;","Cane Minore","Gomeisa",7,27,9.038,8,17,21.5,0,0,-0.0035,0,0,-0.038,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.10","170.23","SS","B8"),new starcat("&alpha;2","Cani","Cor Caroli",12,56,1.67,38,19,6.22,0,0,-0.0198,0,0,0.057,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.90","110.19","SD","A0"),new starcat("&alpha;","Cigno","Deneb",20,41,25.93,45,16,49.29,0,0,0.0004,0,0,0.002,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.30","3229.27","SD","A2"),new starcat("&beta;1","Cigno","Albireo",19,30,43.309,27,57,34.59,0,0,0.0003,0,0,-0.004,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.20","385.53","SD","K3"),new starcat("&gamma;","Cigno","Sadr",20,22,13.71,40,15,24.12,0,0,0.0004,0,0,0.000,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.30","1524.10","SD","F8"),new starcat("&alpha;","Colomba","Phact",5,39,38.953,-34,-4,-27.11,0,0,0.0006,0,0,-0.027,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.80","268.22","SD","B5"),new starcat("&alpha;","Corona&nbsp;Australe","Alfecca&nbsp;Meridiana",19,9,28.334,-37,-59,-16.35,0,0,0.0072,0,0,-0.1,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.10","129.68","SS","A2"),new starcat("&alpha;","Corona Boreale","Alphecca",15,34,41.28,26,42,52.98,0,0,0.0091,0,0,-0.088,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.30","74.72","SS","A0"),new starcat("&alpha;1","Croce del sud","Acrux",12,26,35.948,-63,-5,-56.5,0,0,-0.0044,0,0,-0.012,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.60","320.70","SD","B1"),new starcat("&beta;","Croce del sud","Mimosa",12,47,43.293,-59,-41,-19.34,0,0,-0.0056,0,0,-0.012,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.50","352.60","SD","B1"),new starcat("&alpha;","Delfino","Sualocin",20,39,38.295,15,54,43.29,0,0,0.0046,0,0,-0.002,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.90","240.71","SD","B8"),new starcat("&beta;","Delfino","Rotanev",20,37,32.956,14,35,42.63,0,0,0.0078,0,0,-0.033,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.70","97.39","SD","F5"),new starcat("&alpha;","Drago","Thuban",14,4,23.349,64,22,33.02,0,0,-0.0083,0,0,0.018,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.65","308.86","SS","A0"),new starcat("&beta;","Drago","Rastaban",17,30,25.957,52,18,5.07,0,0,-0.0017,0,0,0.014,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.79","361.59","SD","G2"),new starcat("&gamma;","Drago","Etamin",17,56,36.375,51,29,20.26,0,0,-0.0007,0,0,-0.019,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.23","147.58","SD","K5"),new starcat("&beta;","Ercole","Kornephoros",16,30,13.2,21,29,22.49,0,0,-0.007,0,0,-0.015,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.77","147.78","SS","G7"),new starcat("k","Ercole","Mirfak",16,8,4.54,17,2,48.92,0,0,-0.0021,0,0,-0.008,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","5.00","388.28","SD","G8"),new starcat("&alpha;","Eridano","Achernar",1,37,42.925,-57,-14,-12.13,0,0,0.0127,0,0,-0.034,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","0.46","143.81","SS","B3"),new starcat("&beta;","Eridano","Cursa",5,7,50.969,-5,-5,-11.17,0,0,-0.0063,0,0,-0.08,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.79","88.85","SS","A3"),new starcat("&gamma;","Eridano","Zaurak",3,58,1.773,-13,-30,-30.64,0,0,0.0043,0,0,-0.11,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.95","221.12","SD","M0"),new starcat("&alpha;","Gemelli","Castor",7,34,35.864,31,53,17.63,0,0,-0.0135,0,0,-0.099,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.98","51.55","SD","A1"),new starcat("&beta;","Gemelli","Pollux",7,45,18.943,28,1,34.28,0,0,-0.0474,0,0,-0.046,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.14","33.71","SD","K0"),new starcat("&delta;","Gemelli","Wasat",7,20,7.366,21,58,56.39,0,0,-0.0019,0,0,-0.011,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.53","58.82","SD","F2"),new starcat("&epsilon;","Gemelli","Mebsuta",6,43,55.922,25,7,51.89,0,0,-0.0004,0,0,-0.014,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.98","903.48","SD","G8"),new starcat("&alpha;","Leone","Regulus",10,8,22.317,11,58,2.02,0,0,-0.0169,0,0,0.008,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.35","77.49","SD","B7"),new starcat("&beta;","Leone","Denebola",11,49,3.582,14,34,19.4,0,0,-0.0342,0,0,-0.114,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.14","36.18","SD","A3"),new starcat("&delta;","Leone","Zosma",11,14,6.498,20,31,25.26,0,0,0.0102,0,0,-0.13,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.56","57.71","SS","A4"),new starcat("&alpha;","Lepre","Arneb",5,32,43.799,-17,-49,-20.24,0,0,0,0,0,0.002,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.58","1284.08","SD","F0"),new starcat("&alpha;","Lira","Vega",18,36,56.336,38,47,1.18,0,0,0.0173,0,0,0.286,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","0.03","25.30","SD","A0"),new starcat("&beta;","Lira","Sheliak",18,50,4.8,33,21,45.75,0,0,0.0003,0,0,-0.002,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.45","881.50","SD","B8"),new starcat("&gamma;","Lira","Sulaphat",18,58,56.614,32,41,22.32,0,0,-0.0003,0,0,0.001,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.24","634.55","SD","B9"),new starcat("&alpha;","Ofiuco","Rasalhague",17,34,56.075,12,33,36.21,0,0,0.0082,0,0,-0.226,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.08","46.70","SS","A5"),new starcat("&beta;","Ofiuco","Cebalrai",17,43,28.357,4,34,2.2,0,0,-0.0027,0,0,0.159,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.77","81.99","SS","K2"),new starcat("&alpha;","Orione","Betelgeuse",5,55,10.321,7,24,25.43,0,0,0.0019,0,0,0.01,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","0.50","427.47","SD","M1"),new starcat("&beta;","Orione","Rigel",5,14,32.281,-8,-12,-6,0,0,0.0002,0,0,-0.002,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","0.12","772.88","SD","B8"),new starcat("&delta;","Orione","Mintaka",5,32,0.397,-0,-17,-56.81,0,0,0.0001,0,0,-0.002,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.23","916.17","SD","O9"),new starcat("&epsilon;","Orione","Alnilam",5,36,12.812,-1,-12,-7.05,0,0,0.0001,0,0,-0.002,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.70","1342.21","SS","B0"),new starcat("&gamma;","Orione","Bellatrix",5,25,7.855,6,20,58.66,0,0,-0.0006,0,0,-0.015,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.64","243.04","SS","B2"),new starcat("&alpha;","Orsa Maggiore","Dubhe",11,3,43.695,61,45,3.17,0,0,-0.0164,0,0,-0.067,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.79","123.64","SD","K0"),new starcat("&beta;","Orsa Maggiore","Merak",11,01,50.49,56,22,56.57,0,0,0.01,0,0,0.033,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.37","79.41","SS","A1"),new starcat("&delta;","Orsa Maggiore","Megrez",12,15,25.57,57,1,57.35,0,0,0.0128,0,0,0.009,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.31","81.44","SS","A3"),new starcat("&epsilon;","Orsa Maggiore","Alioth",12,54,1.757,55,57,35.55,0,0,0.0134,0,0,-0.005,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.77","80.93","SS","A0"),new starcat("&gamma;","Orsa Maggiore","Phad",11,53,49.835,53,41,41.15,0,0,0.0107,0,0,0.012,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.44","83.65","SS","A0"),new starcat("&eta;","Orsa Maggiore","Alkaid",13,47,32.44,49,18,48.06,0,0,-0.0124,0,0,-0.01,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.86","100.70","SS","B3"),new starcat("&iota;","Orsa Maggiore","Talitha",8,59,12.452,48,2,29.76,0,0,-0.0442,0,0,-0.229,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.14","47.74","SD","A7"),new starcat("&zeta;","Orsa Maggiore","Mizar",13,23,55.55,54,55,31.39,0,0,0.0142,0,0,-0.02,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.27","78.16","SD","A1"),new starcat("&alpha;","Orsa Minore","Polaris",2,31,48.711,89,15,50.64,0,0,0.2012,0,0,-0.016,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.02","431.42","SD","F7"),new starcat("&beta;","Orsa Minore","Kocab",14,50,42.375,74,9,19.74,0,0,-0.0073,0,0,0.012,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.08","126.47","SS","K4"),new starcat("&alpha;","Pegaso","Markab",23,4,45.656,15,12,18.89,0,0,0.0043,0,0,-0.042,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.49","139.62","SS","B9"),new starcat("&epsilon;","Pegaso","Eniph",21,44,11.166,9,52,30,0,0,0.0021,0,0,0,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.39","672.49","SD","K2"),new starcat("&gamma;","Pegaso","Algenib",0,13,14.156,15,11,0.8,0,0,0.0002,0,0,-0.012,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.83","333.15","SS","B2"),new starcat("&zeta;","Pegaso","Homam",22,41,27.732,10,49,52.79,0,0,0.0055,0,0,-0.013,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.40","208.54","SD","B8"),new starcat("&alpha;","Perseo","Mirfak",3,24,19.371,49,51,40.31,0,0,0.0025,0,0,-0.025,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.79","591.94","SS","F5"),new starcat("&beta;","Perseo","Algol",3,8,10.131,40,57,20.44,0,0,0.0003,0,0,-0.001,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.12","92.82","SD","B8"),new starcat("&alpha;","Pesce Australe","Fomalhaut",22,57,39.071,-29,-37,-20.09,0,0,0.0257,0,0,-0.165,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.16","25.07","SS","A3"),new starcat("&alpha;","Pesci","Alrescha",2,2,2.81,2,45,49.12,0,0,0.0022,0,0,-0.005,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","4.33","139.09","SD","A0"),new starcat("&epsilon;","Sagittario","Kaus Australis",18,24,10.371,-34,-23,-4.9,0,0,-0.0026,0,0,-0.126,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.85","144.64","SD","B9"),new starcat("&alpha;","Scorpione","Antares",16,29,24.449,-26,-25,-55.17,0,0,-0.0006,0,0,-0.021,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","0.96","603.99","SD","M1"),new starcat("&lambda;","Scorpione","Shaula",17,33,36.551,-37,-6,-13.61,0,0,0.0001,0,0,-0.028,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.63","702.92","SS","B2"),new starcat("&alpha;","Serpente","Unukalhay",15,44,16.092,6,25,32.34,0,0,0.0092,0,0,0.047,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.65","73.23","SD","K2"),new starcat("&alpha;","Toro","Aldebaran",4,35,55.243,16,30,33.36,0,0,0.0045,0,0,-0.19,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","0.85","65.11","SD","K5"),new starcat("&beta;","Toro","Alnath",5,26,17.516,28,36,26.63,0,0,0.0018,0,0,-0.176,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","1.65","131.04","SS","B7"),new starcat("&eta;","Toro","Alcyone",3,47,29.074,24,6,18.33,0,0,0.0013,0,0,-0.047,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.87","367.71","SS","B7"),new starcat("&alpha;","Vergine","Spica",13,25,11.601,-11,-9,-40.64,0,0,-0.0026,0,0,-0.027,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","0.98","262.18","SS","B1"),new starcat("&beta;","Vergine","Zavijah",11,50,41.726,1,45,52.9,0,0,0.0496,0,0,-0.271,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","3.61","35.55","SS","F9"),new starcat("&epsilon;","Vergine","Vindemiatrix",13,2,10.599,10,57,32.98,0,0,-0.0186,0,0,0.021,"---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","---","2.83","102.24","SS","G8"));
		giorno=myParseFloat(obj.giorno.value);
		if(giorno>31|giorno<=0)
			{
			alert("\n GIORNO ERRATO: \n\n DATI VALIDI DA 1 A 31 \n\n CLICCA SU RESET E RIPROVA")
		}
		mese=myParseFloat(obj.mese.value);
		if(mese>12|mese<=0)
			{
			alert("\n MESE ERRATO: \n\n DATI VALIDI DA 1 A 12 \n\n CLICCA SU RESET E RIPROVA")
		}
		anno=myParseFloat(obj.anno.value);
		if(anno==0)
			{
			alert("\n ANNO ERRATO: \n\n L'ANNO CIVILE NON PREVEDE L'ANNO ZERO \n\n CLICCA SU RESET E RIPROVA");
			return
		}
		if(anno<0)
			{
			anno=anno+1
		}
		ore=myParseFloat(obj.ore.value);
		if(ore>=24|ore<0)
			{
			alert("\n ORE ERRATE: \n\n DATI VALIDI DA 0 A 23 \n\n CLICCA SU RESET E RIPROVA")
		}
		minuti=myParseFloat(obj.minuti.value);
		if(minuti>=60|minuti<0)
			{
			alert("\n MINUTI ERRATI: \n\n DATI VALIDI DA 0 A 59 \n\n CLICCA SU RESET E RIPROVA")
		}
		secondi=myParseFloat(obj.secondi.value);
		if(secondi>=60|secondi<0)
			{
			alert("\n SECONDI ERRATI: \n\n DATI VALIDI DA 0 A 59 \n\n CLICCA SU RESET E RIPROVA")
		}
		lat_G=myParseFloat(obj.lat_G.value);
		if(lat_G>=90|lat_G<=-90)
			{
			alert("\n GRADI LATITUDINE ERRATI: \n\n DATI VALIDI DA -89 A +89 \n\n CLICCA SU RESET E RIPROVA")
		}
		lat_M=myParseFloat(obj.lat_M.value);
		if(lat_M>=60|lat_M<=-60)
			{
			alert("\n PRIMI LATITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA")
		}
		lat_S=myParseFloat(obj.lat_S.value);
		if(lat_S>=60|lat_S<=-60)
			{
			alert("\n SECONDI LATITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA")
		}
		long_G=myParseFloat(obj.long_G.value);
		if(long_G>=180|long_G<=-180)
			{
			alert("\n GRADI LONGITUDINE ERRATI: \n\n DATI VALIDI DA -179 A +179 \n\n CLICCA SU RESET E RIPROVA")
		}
		long_M=myParseFloat(obj.long_M.value);
		if(long_M>=60|long_M<=-60)
			{
			alert("\n PRIMI LONGITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA")
		}
		long_S=myParseFloat(obj.long_S.value);
		if(long_S>=60|long_S<=-60)
			{
			alert("\n SECONDI LONGITUDINE ERRATI: \n\n DATI VALIDI DA -59 A +59 \n\n CLICCA SU RESET E RIPROVA")
		}
		for(var i=0;
		i<stars.length;
		i++)
			{
			astro_h=stars[i].ra_h;
			astro_m=stars[i].ra_m;
			astro_s=stars[i].ra_s;
			astro_g=stars[i].de_g;
			astro_p=stars[i].de_p;
			astro_ss=stars[i].de_ss;
			astro_mph=stars[i].mpra_h;
			astro_mpm=stars[i].mpra_m;
			astro_mps=stars[i].mpra_s;
			astro_mpg=stars[i].mpde_g;
			astro_mpp=stars[i].mpde_p;
			astro_mpss=stars[i].mpde_ss;
			astro_ra=(astro_s/ 3600 + astro_m /60+astro_h)*15;
			astro_dec=astro_ss/ 3600 + astro_p /60+astro_g;
			astro_mpra=(astro_mps/ 3600 + astro_mpm /60+astro_mph)*15;
			astro_mpdec=astro_mpss/ 3600 + astro_mpp /60+astro_mpg;
			if(obj.giorno.value<10)
				{
				obj.giorno.value="0"+obj.giorno.value
			};
			if(obj.mese.value<10)
				{
				obj.mese.value="0"+obj.mese.value
			};
			s=(obj.anno.value+obj.mese.value+obj.giorno.value);
			s=parseInt(s);
			obj.giorno.value=giorno;
			obj.mese.value=mese;
			giorno_dec=(secondi/ 3600 + minuti /60+ore)/24+giorno;
			ore_dec=secondi/ 3600 + minuti /60+ore;
			JD_0=jd_ore_0();
			JD_UT=jd_ore_ut();
			stars[i].ra_h1=ascdec()[34];
			stars[i].ra_m1=ascdec()[35];
			stars[i].ra_s1=ascdec()[36].toFixed(2);
			stars[i].sgn_dec=ascdec()[40];
			stars[i].de_g1=ascdec()[37];
			stars[i].de_p1=ascdec()[38];
			stars[i].de_ss1=ascdec()[39].toFixed(2);
			stars[i].sgn_h=altaz()[8];
			stars[i].h_g=altaz()[2];
			stars[i].h_p=altaz()[3];
			stars[i].h_ss=altaz()[4].toFixed(2);
			stars[i].a_g=altaz()[5];
			stars[i].a_p=altaz()[6];
			stars[i].a_ss=altaz()[7].toFixed(2);
			stars[i].sgn_e=coecl()[6];
			stars[i].laec_g=coecl()[0];
			stars[i].laec_p=coecl()[1];
			stars[i].laec_ss=coecl()[2].toFixed(2);
			stars[i].loec_g=coecl()[3];
			stars[i].loec_p=coecl()[4];
			stars[i].loec_ss=coecl()[5].toFixed(2)
		}
		var swin=window.open("","stars","menubar,scrollbars,resizable,width=750,height=550");
		with(swin.document)
			{
			writeln("<HTML>");
			writeln("<HEAD>");
			writeln("<TITLE>Calcolo Effemeridi - Stelle luminose</TITLE>");
				writeln("<style>body,td,th {color: #000;} body {background-color:#999} #table{background-color:#999; border-radius: 8px;border:2px solid;border-color:#000;color: #FFF;box-shadow:5px 5px 10px #000;} a:link {color: #FFF;} a:visited {color:#FFF;}a:hover{color:#0F0;</style>");
			writeln("</HEAD>");
				if(anno==0)
					{
					anno=-1
				}
				else if(anno<0)
					{
					anno=anno-1
				}
				writeln("<BODY>");
				writeln("<CENTER>");
				writeln("<table border=\"0\" cellpadding=\"5\" ");
				writeln("<TR>");
				if(lat_G<0|lat_M<0|lat_S<0)
					{
					segn_lat=" Sud";
					lat_G=Math.abs(lat_G);
					lat_M=Math.abs(lat_M);
					lat_S=Math.abs(lat_S)
				}
				else
					{
					segn_lat=" Nord"
				}
				if(long_G<0|long_M<0|long_S<0)
					{
					segn_long=" Ovest";
					long_G=Math.abs(long_G);
					long_M=Math.abs(long_M);
					long_S=Math.abs(long_S)
				}
				else
					{
					segn_long=" Est"
				}
				writeln("<TD align=center> <b> Dati del "+giorno+"/"+mese+"/"+anno+" alle ore "+ore+":"+minuti+":"+secondi+" in posizione geografica "+lat_G+"&ordm;"+lat_M+"'"+lat_S+"''"+segn_lat+"&nbsp;&nbsp;&nbsp;&nbsp;"+long_G+"&ordm;"+long_M+"'"+long_S+"''"+segn_long+"<br>"+" I dati di &alpha;e &delta;delle stelle al 2000, i moti propri, le magnitudini, le distanze, il tipo e le classi spettrali sono stati ricavati dal data base SAO (Smithsonian Astrophisical Observatory Catalogue)"+"</TD>");
				writeln("</TR></TABLE>");
				writeln("<table border=\"0\" cellpadding=\"5\" ");
				writeln("<TR>");
				writeln("<TD  align=center>&nbsp;</TD>");
				writeln("<TD  align=center>&nbsp;</TD>");
				writeln("<TD  align=center>&nbsp;</TD>");
				writeln("<TD  align=center>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</TD>");
				writeln("<TD  align=center>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</TD>");
				writeln("<TD  align=center>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</TD>");
				writeln("<TD  align=center>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</TD>");
				writeln("<TD  align=center>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</TD>");
				writeln("<TD  align=center>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</TD>");
				writeln("<TD  align=center>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</TD>");
				writeln("<TD  align=center>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</TD>");
				writeln("<TD  align=center>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</TD>");
				writeln("<TD  align=center>&nbsp;</TD>");
				writeln("<TD  align=center>&nbsp;</TD>");
				writeln("<TD  align=center>&nbsp;</TD>");
				writeln("<TR>");
				writeln("<TD align=left><A HREF=\"javascript:window.print()\">Stampa</A>&nbsp;<A HREF=\"javascript:window.close()\">Chiudi</A></TD></TR>");
				writeln("<TR>");
				writeln("<TD bgcolor=#CCCCCC align=center><strong>Simbolo</TD>");
				writeln("<TD bgcolor=#CCCCCC align=center><strong>Costellazione</TD>");
				writeln("<TD bgcolor=#CCCCCC align=center><strong>Stella</TD>");
				writeln("<TD bgcolor=#CCCCCC align=center><strong>Asc. Retta 2000 </TD>");
				writeln("<TD bgcolor=#CCCCCC align=center><strong>Declinazione 2000</TD>");
				writeln("<TD bgcolor=#CCCCCC align=center><strong>Asc. Retta </TD>");
				writeln("<TD bgcolor=#CCCCCC align=center><strong>Declinazione </TD>");
				writeln("<TD bgcolor=#CCCCCC align=center><strong>Altezza </TD>");
				writeln("<TD bgcolor=#CCCCCC align=center><strong>Azimut </TD>");
				writeln("<TD bgcolor=#CCCCCC align=center><strong>Lat. Eccl. </TD>");
				writeln("<TD bgcolor=#CCCCCC align=center><strong>Long. Eccl. </TD>");
				writeln("<TD bgcolor=#CCCCCC align=center><strong>Mg</TD>");
				writeln("<TD bgcolor=#CCCCCC align=center><strong>Distanza in AL</TD>");
				writeln("<TD bgcolor=#CCCCCC align=center><strong>Tipo</TD>");
				writeln("<TD bgcolor=#CCCCCC align=center><strong>Classe Spettrale</TD>");
				for(var i=0;
				i<stars.length;
				i++)
					{
					writeln("<TR><TD bgcolor=#CCCCCC align=center>"+stars[i].star+"</TD>");
					writeln("<TD bgcolor=#CCCCCC align=center>"+stars[i].cons+"</TD>");
					writeln("<TD bgcolor=#CCCCCC align=center>"+stars[i].name+"</TD>");
					writeln("<TD bgcolor=#CCCCCC align=center>"+stars[i].ra_h+" : "+stars[i].ra_m+" : "+stars[i].ra_s+"</TD>");
					if(stars[i].de_g<0|stars[i].de_p<0|stars[i].de_ss<0)
						{
						segno="- "
					}
					else
						{
						segno="+ "
					}
					writeln("<TD bgcolor=#CCCCCC align=center>"+segno+Math.abs(stars[i].de_g)+"&ordm;"+Math.abs(stars[i].de_p)+"' "+Math.abs(stars[i].de_ss)+"'' "+"</TD>");
					writeln("<TD bgcolor=#CCCCCC align=center>"+stars[i].ra_h1+" : "+stars[i].ra_m1+" : "+stars[i].ra_s1+"</TD>");
					writeln("<TD bgcolor=#CCCCCC align=center>"+stars[i].sgn_dec+stars[i].de_g1+"&ordm;"+stars[i].de_p1+"' "+stars[i].de_ss1+"'' "+"</TD>");
					writeln("<TD bgcolor=#CCCCCC align=center>"+stars[i].sgn_h+stars[i].h_g+"&ordm;"+stars[i].h_p+"' "+stars[i].h_ss+"'' "+"</TD>");
					writeln("<TD bgcolor=#CCCCCC align=center>"+stars[i].a_g+"&ordm;"+stars[i].a_p+"' "+stars[i].a_ss+"'' "+"</TD>");
					writeln("<TD bgcolor=#CCCCCC align=center>"+stars[i].sgn_e+stars[i].laec_g+"&ordm;"+stars[i].laec_p+"' "+stars[i].laec_ss+"'' "+"</TD>");
					writeln("<TD bgcolor=#CCCCCC align=center>"+stars[i].loec_g+"&ordm;"+stars[i].loec_p+"' "+stars[i].loec_ss+"'' "+"</TD>");
					writeln("<TD bgcolor=#CCCCCC align=center>"+stars[i].mg+"</TD>");
					writeln("<TD bgcolor=#CCCCCC align=center>"+stars[i].al+"</TD>");
					writeln("<TD bgcolor=#CCCCCC align=center>"+stars[i].type+"</TD>");
					writeln("<TD bgcolor=#CCCCCC align=center>"+stars[i].spec+"</TD>");
				}
				writeln("</TABLE><P>");
				writeln("<TABLE border=\"0\" cellpadding=\"5\" ><TR>");
				writeln("<tr> <td> <b> Agostino Frosini  -  JavaScript Software 2015  - </TD>");
				writeln("</TR></TABLE></CENTER></BODY></HTML>");
				close()
			}
			swin.focus()
		}
		else
			{
			alert("ERRORE\n\nHAI TENTATO DI MODIFICARE LA PAGINA WEB\n\nSPIACENTE IL PROGRAMMA NON FUNZIONERA' PIU'")
		}
	}
	